<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 50);
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->enum('role', array('ccc_coordinator', 'coordinator', 'intake_personal', 'director', 'emergency_line_worker', 'admin', 'case_menanger', 'senior_coordinator'));
			$table->enum('language', array('english', 'deutch'));
			$table->integer('coutry_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}