<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('related', 255);
			$table->enum('type', array('call', 'research', 'mail', 'meeting', 'ex_app'));
			$table->enum('priority', array('priority'));
			$table->enum('status', array('resolved'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}