<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->enum('sunday_availability', array('0', '1'));
			$table->enum('priority_followup', array('0', '1'));
			$table->enum('met', array('0', '1'));
			$table->integer('consult_rate');
			$table->integer('surgery_rate');
			$table->string('home_number', 25);
			$table->string('cell_number', 25);
			$table->string('additional_number', 25);
			$table->string('mail', 50);
			$table->integer('assistent_id');
			$table->string('zip_code', 50);
			$table->timestamps();
			$table->integer('updated_user_id');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}