<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shipment extends Eloquent {

	protected $table = 'inbound_shipments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_id', 'tracking_id', 'origin', 'destination', 'status');

	public function customer()
	{
		return $this->belongsTo('Customer', 'id', 'customer_id');
	}

	public function payment_type()
	{
		return $this->belongsTo('App\Models\PaymentType', 'payment_id', 'id');
	}

}