<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressbookTable extends Migration {

	public function up()
	{
		Schema::create('addressbook', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id')->nullable()->index();
			$table->string('name', 60)->nullable();
			$table->string('surname', 60)->nullable();
			$table->string('email', 60)->nullable();
			$table->string('phone', 60)->nullable();
			$table->string('postal_code', 16)->nullable();
			$table->string('street', 155)->nullable();
			$table->string('number', 60)->nullable();
			$table->string('comment', 500)->nullable();
			$table->string('contact_person_name', 60)->nullable();
			$table->string('contact_person_email', 60)->nullable();
			$table->string('contact_person_phone', 60)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('addressbook');
	}
}