<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('inbound_shipments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inbound_shipments', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parcels', function(Blueprint $table) {
			$table->foreign('shipment_id')->references('id')->on('inbound_shipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('inbound_shipments', function(Blueprint $table) {
			$table->dropForeign('inbound_shipments_customer_id_foreign');
		});
		Schema::table('inbound_shipments', function(Blueprint $table) {
			$table->dropForeign('inbound_shipments_payment_id_foreign');
		});
		Schema::table('parcels', function(Blueprint $table) {
			$table->dropForeign('parcels_shipment_id_foreign');
		});
	}
}