<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppClientsTable extends Migration {

	public function up()
	{
		Schema::create('app_clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191)->index();
			$table->string('email', 100)->unique();
			$table->string('address', 191)->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('phone2', 20)->nullable();
			$table->string('website', 191)->nullable();
			$table->boolean('status')->default(1);
			$table->integer('user_id')->unique()->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('app_clients');
	}
}