<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sector extends Eloquent {

	protected $table = 'sectors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'desc_ar', 'desc_en');

	public function activities()
	{
		return $this->hasMany('App\Models\ActivityType');
	}

}