<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname');
			$table->string('email');
			$table->string('dial_code', 5);
			$table->string('mobile_number');
			$table->string('avatar_url');
			$table->boolean('mobile_verified')->nullable();
			$table->boolean('email_verfied')->nullable()->default(0);
			$table->tinyInteger('is_active');
			$table->string('password');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}