<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model 
{

    protected $table = 'settings';
    public $timestamps = true;
    protected $fillable = array('email', 'logo', 'footer_logo', 'work_time');

    public function translations()
    {
        return $this->hasMany('Models\SettingTranslation', 'setting_id');
    }

    public function phones()
    {
        return $this->morphMany('Models\Setting', 'phoneable', 'phoneable_type', 'phoneable_id');
    }

}