<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('StoreStaffMonthly', function(Blueprint $table) {
			$table->foreign('StaffID')->references('id')->on('StoreStaff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('StoreStaffAssign', function(Blueprint $table) {
			$table->foreign('StaffMonthlyID')->references('id')->on('StoreStaffMonthly')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('StoreStaffAbsence', function(Blueprint $table) {
			$table->foreign('StaffID')->references('id')->on('StoreStaff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('StoreStaffMonthly', function(Blueprint $table) {
			$table->dropForeign('StoreStaffMonthly_StaffID_foreign');
		});
		Schema::table('StoreStaffAssign', function(Blueprint $table) {
			$table->dropForeign('StoreStaffAssign_StaffMonthlyID_foreign');
		});
		Schema::table('StoreStaffAbsence', function(Blueprint $table) {
			$table->dropForeign('StoreStaffAbsence_StaffID_foreign');
		});
	}
}