<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkingHours extends Model 
{

    protected $table = 'WorkingHours';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('CostCenter', 'Month', 'Year', 'HoursType', 'HoursTotal');
    protected $visible = array('CostCenter', 'Month', 'Year', 'HoursType', 'HoursTotal');

    public function CostCenter()
    {
        return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
    }

}