<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinancialData extends Model 
{

    protected $table = 'FinancialData';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('CostCenter', 'FinancialAccount', 'Month', 'Year', 'Value');
    protected $visible = array('CostCenter', 'FinancialAccount', 'Month', 'Year', 'Value');

    public function Store()
    {
        return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
    }

    public function FinancialAccount()
    {
        return $this->hasOne('BESTSELLER\FinancialAccount', 'AccountID', 'FinancialAccount');
    }

}