<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreStaff extends Eloquent {

	protected $table = 'StoreStaff';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('LODASNo', 'Firstname', 'Lastname', 'StartDate', 'EndDate');
	protected $visible = array('LODASNo', 'Firstname', 'Lastname', 'StartDate', 'EndDate');

	public function MonthlyData()
	{
		return $this->hasMany('BESTSELLER\StoreStaffMonth', 'id', 'StaffID');
	}

	public function Absence()
	{
		return $this->hasMany('BESTSELLER\StoreStaffAbsence', 'StaffID');
	}

}