<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Device extends Model 
{

    protected $table = 'devices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sensors()
    {
        return $this->hasMany('Sensor');
    }

    public function data()
    {
        return $this->hasManyThrough('SensorData', 'Sensor');
    }

}