<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductsModel extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'product_title', 'brand_id', 'category_id', 'subcategory_id', 'child_category_id', 'image', 'slug', 'status');

	public function images()
	{
		return $this->hasMany('App\ProductImagesModel', 'product_id');
	}

	public function variants()
	{
		return $this->hasMany('App\ProductVariantMapModel', 'product_id');
	}

	public function category()
	{
		return $this->hasOne('App\CategoriesModel', 'category_id');
	}

	public function subCategory()
	{
		return $this->hasOne('App\CategoriesModel', 'subcategory_id');
	}

	public function childCategory()
	{
		return $this->hasOne('App\CategoriesModel', 'child_category_id');
	}

}