<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductVariantMapModel extends Eloquent {

	protected $table = 'product_variant_map';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'product_id', 'product_sub_title', 'product_sku', 'variant_id', 'variant_value_id', 'unit_id', 'regular_price', 'discount_type', 'discount_value', 'sale_price', 'in_stock', 'tax_id', 'product_description', 'status');

	public function details()
	{
		return $this->belongsTo('App\ProductsModel', 'product_id');
	}

	public function variantData()
	{
		return $this->belongsTo('App\VariantsModel', 'variant_id');
	}

	public function variantValueData()
	{
		return $this->belongsTo('App\VariantValuesModel', 'variant_value_id');
	}

	public function unit()
	{
		return $this->belongsTo('App\UnitsModel', 'unit_id');
	}

	public function tax()
	{
		return $this->belongsTo('App\TaxesModel', 'tax_id');
	}

}