<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoriesModel extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('parent_id', 'image', 'status');
	protected $fillable = array('category_name', 'slug');
	protected $visible = array('category_name', 'slug');

	public function products()
	{
		return $this->hasMany('App\ProductsModel');
	}

}