<?php

namespace App;

class CartsModel extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;
	protected $guarded = array('unique_id', 'user_id', 'product_variant_map_id', 'quantity');

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function product()
	{
		return $this->belongsTo('App\ProductVariantMapModel', 'product_variant_map_id');
	}

}