<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('shipping_id')->unsigned()->index();
			$table->integer('payment_id')->unsigned()->index();
			$table->decimal('order_total')->nullable();
			$table->decimal('total_discount')->default('0');
			$table->decimal('delivery_charge');
			$table->decimal('total_tax')->default('0');
			$table->decimal('gross_amount')->default('0');
			$table->enum('status', array('Pending', 'Packed', 'Shipped', 'Delivered', 'Canceled', 'Refunded'))->nullable();
			$table->timestamp('order_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}