<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('product_title')->nullable();
			$table->integer('brand_id')->unsigned()->index();
			$table->integer('category_id')->unsigned()->index();
			$table->integer('subcategory_id')->unsigned()->index();
			$table->integer('child_category_id')->unsigned()->index();
			$table->string('image')->nullable();
			$table->string('slug')->nullable();
			$table->enum('status', array('Active', 'Inactive', 'Deleted'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}