<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupportTable extends Migration {

	public function up()
	{
		Schema::create('support', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('started_user_id')->unsigned();
			$table->string('url', 254);
			$table->smallInteger('invoice');
			$table->smallInteger('message');
			$table->string('file', 254);
			$table->tinyInteger('immediate');
			$table->text('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('support');
	}
}