<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('from');
			$table->datetime('to');
			$table->string('location');
			$table->timestamps();
			$table->string('photo', 500);
			$table->integer('hosted_by')->unsigned();
			$table->string('title', 100);
			$table->text('description');
			$table->boolean('has_chat');
			$table->string('has_coach');
			$table->integer('attendance_limit')->nullable();
			$table->enum('attendence_gender', array('male', 'female', 'another'))->nullable();
			$table->string('attendence_min_age');
			$table->integer('attendence_max_age')->nullable();
			$table->boolean('visible_to_all');
			$table->boolean('request_needed');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}