<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('activity_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activity_user', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('actvities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activity_event', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activity_event', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('actvities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('hosted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_interest', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_interest', function(Blueprint $table) {
			$table->foreign('interest_id')->references('id')->on('interests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('activity_user', function(Blueprint $table) {
			$table->dropForeign('activity_user_user_id_foreign');
		});
		Schema::table('activity_user', function(Blueprint $table) {
			$table->dropForeign('activity_user_activity_id_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_user_id_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_event_id_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_group_id_foreign');
		});
		Schema::table('activity_event', function(Blueprint $table) {
			$table->dropForeign('activity_event_event_id_foreign');
		});
		Schema::table('activity_event', function(Blueprint $table) {
			$table->dropForeign('activity_event_activity_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_hosted_by_foreign');
		});
		Schema::table('group_interest', function(Blueprint $table) {
			$table->dropForeign('group_interest_group_id_foreign');
		});
		Schema::table('group_interest', function(Blueprint $table) {
			$table->dropForeign('group_interest_interest_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_user_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_group_id_foreign');
		});
	}
}