<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('course_category', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('course_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permission')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_master')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('batch', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staffs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('batch', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batch')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batch')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batch')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('education_details', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lesson')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staffs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batch')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staffs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('placement', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('students_applied', function(Blueprint $table) {
			$table->foreign('placement_id')->references('id')->on('placement')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('students_applied', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('batch_course', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batch')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('batch_course', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('course_category', function(Blueprint $table) {
			$table->dropForeign('course_category_course_id_foreign');
		});
		Schema::table('course_category', function(Blueprint $table) {
			$table->dropForeign('course_category_category_id_foreign');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_role_id_foreign');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_permission_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_course_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_module_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_type_id_foreign');
		});
		Schema::table('batch', function(Blueprint $table) {
			$table->dropForeign('batch_staff_id_foreign');
		});
		Schema::table('batch', function(Blueprint $table) {
			$table->dropForeign('batch_course_id_foreign');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->dropForeign('enroll_students_course_id_foreign');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->dropForeign('enroll_students_batch_id_foreign');
		});
		Schema::table('enroll_students', function(Blueprint $table) {
			$table->dropForeign('enroll_students_student_id_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_order_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_student_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_course_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_batch_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_course_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_batch_id_foreign');
		});
		Schema::table('education_details', function(Blueprint $table) {
			$table->dropForeign('education_details_student_id_foreign');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->dropForeign('doubts_lesson_id_foreign');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->dropForeign('doubts_staff_id_foreign');
		});
		Schema::table('doubts', function(Blueprint $table) {
			$table->dropForeign('doubts_student_id_foreign');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->dropForeign('feedback_course_id_foreign');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->dropForeign('feedback_batch_id_foreign');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->dropForeign('feedback_staff_id_foreign');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->dropForeign('feedback_student_id_foreign');
		});
		Schema::table('placement', function(Blueprint $table) {
			$table->dropForeign('placement_course_id_foreign');
		});
		Schema::table('students_applied', function(Blueprint $table) {
			$table->dropForeign('students_applied_placement_id_foreign');
		});
		Schema::table('students_applied', function(Blueprint $table) {
			$table->dropForeign('students_applied_student_id_foreign');
		});
		Schema::table('batch_course', function(Blueprint $table) {
			$table->dropForeign('batch_course_batch_id_foreign');
		});
		Schema::table('batch_course', function(Blueprint $table) {
			$table->dropForeign('batch_course_course_id_foreign');
		});
	}
}