<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTable extends Migration {

	public function up()
	{
		Schema::create('payment', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->nullable();
			$table->string('payment_id')->nullable();
			$table->string('transaction_id')->nullable();
			$table->string('status')->nullable();
			$table->integer('created_by')->nullable();
			$table->string('created_slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payment');
	}
}