<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_number');
			$table->integer('student_id')->unsigned();
			$table->integer('course_id')->unsigned();
			$table->integer('batch_id')->unsigned();
			$table->enum('type', array('0', '1'))->nullable();
			$table->decimal('total_amount', 10,2)->nullable()->default('0.00');
			$table->decimal('amount_paid', 10,2)->nullable()->default('0.00');
			$table->decimal('amount_balance', 10,2)->nullable();
			$table->string('status')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('created_by');
			$table->string('created_slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}