<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationDetailsTable extends Migration {

	public function up()
	{
		Schema::create('education_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('student_id')->unsigned();
			$table->string('slug')->nullable();
			$table->string('grade')->nullable();
			$table->string('yop')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('is_active')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('education_details');
	}
}