<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchTable extends Migration {

	public function up()
	{
		Schema::create('batch', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('staff_id')->unsigned();
			$table->integer('course_id')->unsigned();
			$table->string('name');
			$table->string('slug');
			$table->string('start_date')->nullable();
			$table->string('end_date')->nullable();
			$table->string('hours')->nullable();
			$table->text('days');
			$table->integer('created_by');
			$table->string('created_slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('batch');
	}
}