<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->string('name');
			$table->string('slug');
			$table->integer('position')->default('0');
			$table->tinyInteger('is_active')->default('1');
			$table->integer('created_by')->nullable();
			$table->string('created_slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}