<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFeedbackTable extends Migration {

	public function up()
	{
		Schema::create('feedback', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('batch_id')->unsigned();
			$table->integer('staff_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->string('title')->nullable();
			$table->string('rating')->nullable();
			$table->longText('review')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('feedback');
	}
}