<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('student', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('mobile');
			$table->string('email')->unique();
			$table->string('password');
			$table->date('dob')->nullable();
			$table->decimal('balance_amount', 10,2)->default('0.00');
			$table->tinyInteger('is_enrolled')->default('0');
			$table->tinyInteger('is_active')->default('1');
			$table->tinyInteger('is_balance')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('student');
	}
}