<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseTable extends Migration {

	public function up()
	{
		Schema::create('course', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug')->unique();
			$table->string('cover_image');
			$table->longText('description');
			$table->integer('hours');
			$table->string('certificate_image')->nullable();
			$table->integer('position')->default('0');
			$table->tinyInteger('is_active')->default('1');
			$table->integer('created_by');
			$table->string('created_slug');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('course');
	}
}