<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PATIENT extends Model 
{

    protected $table = 'PATIENTS';
    public $timestamps = false;
    protected $fillable = array('FIRST_NAME', 'LAST_NAME', 'PHONE', 'ADDRESS', 'PHOTO', 'EMAIL', 'PASSWORD', 'IS_ACTIVATED');
    protected $hidden = array('PASSWORD', 'remember_token');

    public function Reservation()
    {
        return $this->hasMany('App\BOOKING', 'PATIENT_ID', 'ID');
    }

    public function MedicalRecord()
    {
        return $this->hasMany('App\MEDICAL_RECORD', 'PATIENT_ID', 'ID');
    }

    public function RequiredTreatment()
    {
        return $this->hasManyThrough('App\REQUIRED_TREATMENT', 'App\MEDICAL_RECORD', 'PATIENT_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
    }

    public function RequiredAnalysis()
    {
        return $this->hasManyThrough('App\REQUIRED_ANALYZE', 'App\MEDICAL_RECORD', 'PATIENT_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
    }

    public function PositiveDisease()
    {
        return $this->hasManyThrough('App\POSITIVE_DISEASE', 'App\MEDICAL_RECORD', 'PATIENT_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
    }

    public function PatientsActivation()
    {
        return $this->hasOne('App\PATIENT_ACTIVATION', 'PATIENT_ID', 'ID');
    }

}