<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketTable extends Migration {

	public function up()
	{
		Schema::create('ticket', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->integer('user_id')->unsigned();
			$table->integer('status_id');
			$table->integer('dept_id');
			$table->integer('topic_id');
			$table->integer('staff_id');
			$table->integer('team_id');
			$table->datetime('duedate');
			$table->datetime('created');
			$table->datetime('last_update');
		});
	}

	public function down()
	{
		Schema::drop('ticket');
	}
}