<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('men', 'women', 'kids'));
			$table->double('price');
			$table->enum('season', array('winter', 'summer', '..'));
			$table->json('description');
			$table->bigInteger('category_id')->unsigned();
			$table->integer('minimum_order_quantity');
			$table->date('discount_start_date');
			$table->date('discount_end_date');
			$table->integer('stock');
			$table->integer('views');
			$table->integer('discount_percentage');
			$table->bigInteger('Material_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}