<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('gender')->nullable();
			$table->date('birthday')->nullable();
			$table->string('profile')->default('uploads/doctors/default.png');
			$table->string('biography')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}