<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTargetAssignmentsTable extends Migration {

	public function up()
	{
		Schema::create('target_assignments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('target_id')->unsigned();
			$table->integer('assignable_id');
			$table->string('assignable_type');
			$table->decimal('assigned_value');
			$table->decimal('current_value');
			$table->boolean('override_auto_accept');
			$table->enum('status', array(''));
			$table->timestamp('completed_at');
		});
	}

	public function down()
	{
		Schema::drop('target_assignments');
	}
}