<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTargetsTable extends Migration {

	public function up()
	{
		Schema::create('targets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('target_type_id')->unsigned();
			$table->enum('period_type', array('daily', 'weekly', 'monthly', 'quarterly', ''));
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->decimal('total_target_value');
			$table->decimal('current_value');
			$table->boolean('is_auto_accept');
			$table->enum('status', array('pending', 'in_progress', 'achieved', 'failed'));
			$table->boolean('auto_distribute');
			$table->longText('description')->nullable();
			$table->boolean('is_recurring');
			$table->date('achieved_at');
		});
	}

	public function down()
	{
		Schema::drop('targets');
	}
}