<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TargetProgressLogs extends Model 
{

    protected $table = 'target_progress_logs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function target()
    {
        return $this->belongsTo('Target');
    }

    public function progressable()
    {
        return $this->morphTo();
    }

    public function assignment()
    {
        return $this->belongsTo('TargetAssignments');
    }

}