<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('reciepient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_statuses', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_statuses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('chats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_media_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_sender_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_reciepient_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_media_id_foreign');
		});
		Schema::table('user_statuses', function(Blueprint $table) {
			$table->dropForeign('user_statuses_media_id_foreign');
		});
		Schema::table('user_statuses', function(Blueprint $table) {
			$table->dropForeign('user_statuses_user_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_user_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_user_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_media_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_user_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_chat_id_foreign');
		});
	}
}