<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('buyer_id')->unsigned();
			$table->integer('seller_id')->unsigned();
			$table->enum('status', array('pending', 'accepted', 'rejected', 'delivered', 'declined'));
			$table->decimal('cost');
			$table->decimal('delivery_cost');
			$table->decimal('total');
			$table->decimal('commission');
			$table->decimal('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}