<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('profile_code');
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->string('address')->nullable();
			$table->string('image')->nullable();
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}