<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('category_id')->unsigned();
			$table->integer('store_id')->unsigned()->nullable();
			$table->integer('outlet_id')->unsigned()->nullable();
			$table->string('code');
			$table->string('name');
			$table->string('description')->nullable();
			$table->string('image');
			$table->decimal('hpp');
			$table->decimal('markup');
			$table->decimal('selling_price');
			$table->integer('stock')->default('0');
			$table->boolean('is_ppn')->default(false);
			$table->boolean('is_discount')->default(false);
			$table->boolean('is_active')->default(true);
			$table->boolean('is_favorite')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}