<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('username');
			$table->string('phone');
			$table->string('email')->unique();
			$table->timestamps();
			$table->string('password');
			$table->integer('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}