<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReferenceRelationshipsTable extends Migration {

	public function up()
	{
		Schema::create('reference_relationships', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_property_id')->unsigned();
			$table->integer('parent_entity_id')->unsigned();
			$table->integer('child_property_id')->unsigned();
			$table->integer('child_entity_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reference_relationships');
	}
}