<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionTable extends Migration {

	public function up()
	{
		Schema::create('Question', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('problem_statement', 2000);
			$table->string('explanation', 1000);
			$table->enum('difficulty', array('easy', 'medium', 'hard'));
		});
	}

	public function down()
	{
		Schema::drop('Question');
	}
}