<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveriesTable extends Migration {

	public function up()
	{
		Schema::create('deliveries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id');
			$table->integer('seller_id')->nullable();
			$table->string('user_name');
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->enum('status', array('pending', 'rejected', 'active', 'deactivate', 'block'));
			$table->string('password')->nullable();
			$table->string('pin_code')->nullable();
			$table->datetime('pin_code_date_expired')->nullable();
			$table->float('max_commission')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('deliveries');
	}
}