<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectAssignmentExecutorsTable extends Migration {

	public function up()
	{
		Schema::create('project_assignment_executors', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26);
			$table->integer('project_assignment_id')->unsigned()->index();
			$table->string('workflow_step_code', 50)->index();
			$table->string('type', 50);
			$table->string('model', 50);
			$table->string('model_id', 50)->index();
			$table->smallInteger('sort_order')->default('0');
			$table->string('status', 20)->default('active');
			$table->jsonb('properties')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('project_assignment_executors');
	}
}