<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->foreign('shipping_mode_id')->references('id')->on('shipping_modes')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('clearance_offices', function(Blueprint $table) {
			$table->foreign('Country')->references('id')->on('country')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('clearance_offices', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('office_ports', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('clearance_office_employee')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('office_ports', function(Blueprint $table) {
			$table->foreign('port_id')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->dropForeign('ports_country_id_foreign');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->dropForeign('ports_city_id_foreign');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->dropForeign('ports_shipping_mode_id_foreign');
		});
		Schema::table('clearance_offices', function(Blueprint $table) {
			$table->dropForeign('clearance_offices_Country_foreign');
		});
		Schema::table('clearance_offices', function(Blueprint $table) {
			$table->dropForeign('clearance_offices_city_id_foreign');
		});
		Schema::table('office_ports', function(Blueprint $table) {
			$table->dropForeign('office_ports_office_id_foreign');
		});
		Schema::table('office_ports', function(Blueprint $table) {
			$table->dropForeign('office_ports_port_id_foreign');
		});
	}
}